import requests
import json
from prettytable import PrettyTable
from requests.packages.urllib3.exceptions import InsecureRequestWarning

requests.packages.urllib3.disable_warnings(InsecureRequestWarning)


class vraclass:

    def __init__(self, vraurl, username, password, tenant):
        self.username = username
        self.password = password
        self.vraurl = vraurl
        self.tenant = tenant

    def vralogin(self):
        url = f"https://{self.vraurl}/identity/api/tokens"
        payload = f'{{"username":"{self.username}","password":"{self.password}","tenant":"{self.tenant}"}}'
        headers = {
            'accept': "application/json",
            'content-type': "application/json",
        }
        response = requests.request("POST", url, data=payload, headers=headers, verify=False)
        outp = response.json()['id']
        token = "Bearer " + outp
        return token

    def list_tenant(self):
        mainurl = f"https://{self.vraurl}/identity/api/tenants"
        vraheaders = {
            'accept': "application/json",
            "authorization": self.vralogin()
        }
        output = requests.request("GET", mainurl, headers=vraheaders, verify=False)
        result = output.json()['content']
        resulTable = PrettyTable(['Type', 'ID', 'URLName', 'Name', 'Description', 'ContactEmail', 'DefaultTenant'])
        print(resulTable)
        for i in result:
            resulTable.add_row(
                (i['@type'], i['id'], i['urlName'], i['name'], i['description'], i['contactEmail'], i['defaultTenant']))
        print(resulTable)

    def create_tenant(self, tenantname, urlName, Description, ContactEmail):
        url = f"https://{self.vraurl}/identity/api/tenants/{urlName}"

        payload = f'{{"@type":"Tenant","id":"{tenantname}","urlName":"{urlName}","name":"{tenantname}","description":"{Description}","contactEmail":"{ContactEmail}","defaultTenant":"false"}}'
        print(type(payload))
        headers = {
            'accept': "application/json",
            'content-type': "application/json",
            "authorization": self.vralogin()

        }
        output = requests.request("PUT", url, data=payload, headers=headers, verify=False)


    def list_Network_Profile(self):
        url = f"https://{self.vraurl}/iaas-proxy-provider/api/network/profiles?limit=10000"
        headers = {
            'accept': "application/json",
            'authorization': self.vralogin(),
            'content-type': "application/json"
        }
        output = requests.request("GET", url, headers=headers, verify=False)
        result = output.json()['content']
        count = 0

        result_table = PrettyTable(
            ['Number','ID', 'NAME', 'CreationDate', 'LastModifiedDate', 'StartIPAddress', 'EndIPAddress', 'SubnetMask',
             'GatewayAddress', 'PrimaryDnsAddress'])
        for i in result:
            count =count+1
            result_table.add_row(
                (count,i['id'], i['name'], i['createdDate'], i['lastModifiedDate'], i['definedRanges'][0]['beginIPv4Address'],
                 i['definedRanges'][0]['endIPv4Address'], i['subnetMask'], i['gatewayAddress'], i['primaryDnsAddress'])
            )
        print(result_table)

    def update_Netork_Profile(self, profileid, beginIP, endIP, defaultGateway):
        url = f"https://{self.vraurl}/iaas-proxy-provider/api/network/profiles/{profileid}"
        headers = {
            'accept': "application/json",
            'authorization': self.vralogin(),
            'content-type': "application/json"
        }
        output = (requests.request("GET", url, headers=headers, verify=False)).json()
        output['definedRanges'][0]['beginIPv4Address'] = beginIP
        output['definedRanges'][0]['endIPv4Address'] = endIP
        output['gatewayAddress'] = defaultGateway
        #output['subnetMask'] = subnetMask
        payload = json.dumps(output)
        finalcall = requests.request("PUT", url, data=payload, headers=headers, verify=False)
        print(finalcall)


    def list_catalog(self, catalogname=None,ServiceName=None):
        if not (catalogname is None) and (ServiceName is None):
            #url = f"https://{self.vraurl}/catalog-service/api/consumer/entitledCatalogItemViews"
            url = f"https://{self.vraurl}/catalog-service/api/consumer/entitledCatalogItemViews?$filter=name+eq+%27{catalogname}%27"
        elif (catalogname is None) and not (ServiceName is None):
            url = f"https://{self.vraurl}/catalog-service/api/consumer/entitledCatalogItemViews?$filter=service/name+eq+%27{ServiceName}%27"
        elif (catalogname is None) and (ServiceName is None):
            url = f"https://{self.vraurl}/catalog-service/api/consumer/entitledCatalogItemViews"

        headers = {
            'accept': "application/json",
            'authorization': self.vralogin(),
            'content-type': "application/json"
        }
        output = requests.request("GET", url, headers=headers, verify=False).json()['content']
        view = PrettyTable(
            ['TenantName', 'CatalogName', 'CatalogItemID', 'Description', 'CreationDate', 'LastModified', 'ServiceName',
             'RequestTemplateLink', 'SubmitRequestLink'])
        for i in output:
            view.add_row(
                (i['entitledOrganizations'][0]['tenantLabel'], i['name'], i['catalogItemId'], i['description'],
                 i['dateCreated'], i['lastUpdatedDate'], i['serviceRef']['label'], i['links'][0]['href'],
                 i['links'][1]['href'])
            )

        return print(view)










