import requests
from prettytable import PrettyTable
from requests.packages.urllib3.exceptions import InsecureRequestWarning
requests.packages.urllib3.disable_warnings(InsecureRequestWarning)

class vraClass:
    def __init__(self, vrafqdn, username, password):
        self.vrafqdn = vrafqdn
        self.username = username
        self.password = password
        url = f"https://{self.vrafqdn}/iaas/api/about"
        headers = {
            'accept': "application/json",
            'content-type': "application/json"
        }
        apioutput = requests.get(url, headers=headers, verify=False).json()['supportedApis']
        for i in apioutput:
            self.apiversion = i['apiVersion']

    def vratoken(self):
        refreshtokenurl = f"https://{self.vrafqdn}/csp/gateway/am/api/login?access_token"
        iaasUrl = f"https://{self.vrafqdn}/iaas/api/login?apiVersion={self.apiversion}"
        headers = {
            'accept': "application/json",
            'content-type': "application/json"
        }
        payload = f'{{"username":"{self.username}","password":"{self.password}"}}'
        apioutput = requests.post(refreshtokenurl, data=payload, verify=False, headers=headers)
        refreshtoken = apioutput.json()['refresh_token']
        iaasPayload = f'{{"refreshToken": "{refreshtoken}"}}'
        iaasApiOutput = requests.post(iaasUrl, data=iaasPayload, headers=headers, verify=False).json()['token']
        bearerToken = "Bearer " + iaasApiOutput
        return bearerToken

    def getDeployments(self):
        url = f"https://{self.vrafqdn}/iaas/api/deployments?%24top=10000&apiVersion={self.apiversion}"
        headers = {
            'accept': "application/json",
            'content-type': "application/json",
            'authorization': self.vratoken()
        }
        api_output = requests.get(url, headers=headers, verify=False).json()['content']
        output_table = PrettyTable(['Number', 'ProjectID', 'DeploymentName', 'DeploymentID'])
        count = 0
        for i in api_output:
            count = count+1
            output_table.add_row(
                (count, i['projectId'], i['name'], i['id'])
            )
        print(output_table)

    def deleteDeployment(self, id):
        url = f"https://{self.vrafqdn}/iaas/api/deployments/{id}?apiVersion={self.apiversion}"
        headers = {
            'accept': "application/json",
            'content-type': "application/json",
            'authorization': self.vratoken()
        }
        apioutput = requests.delete(url, headers=headers, verify=False)
        print(apioutput)

    def getBlueprint(self):
        url = f"https://{self.vrafqdn}/blueprint/api/blueprints"
        headers = {
            'accept': "application/json",
            'content-type': "application/json",
            'authorization': self.vratoken()
        }
        apioutput = requests.get(url, headers=headers, verify=False).json()['content']
        table = PrettyTable(
            ['ID', 'Name', 'Status',  'CreatedBy','UpdatedBY', 'OrgID', 'ProjectID', 'projectName', 'totalVersions', 'totalReleasedVersions']
        )

        for i in apioutput:
            table.add_row(
                (i['id'], i['name'], i['status'], i['createdBy'], i['updatedBy'], i['orgId'], i['projectId'],i['projectName'], i['totalVersions'], i['totalReleasedVersions'])
            )
        print(table)

    def releaseBlueprint(self, id, version):
        url = f"https://{self.vrafqdn}/blueprint/api/blueprints/{id}/versions/{version}/actions/release"
        headers = {
            'accept': "application/json",
            'content-type': "application/json",
            'authorization': self.vratoken()
        }
        apioutput = requests.post(url, headers=headers, verify=False)
        print(apioutput)

    def getMachines(self):
        url = f"https://{self.vrafqdn}/iaas/api/machines?apiVersion={self.apiversion}&%24top=100000"
        headers = {
            'accept': "application/json",
            'content-type': "application/json",
            'authorization': self.vratoken()
        }
        apioutput = requests.get(url, headers=headers, verify=False).json()['content']
        table = PrettyTable(
            ['PoweredState', 'ProvisioningStatus', 'Name', 'ID', 'CreatedAt', 'UpdatedAt']
        )
        for i in apioutput:
            table.add_row(
                (i['powerState'], i['provisioningStatus'], i['name'], i['id'], i['createdAt'], i['updatedAt'])
            )
        print(table)

    def deleteMachine(self, id):
        url = f"https://{self.vrafqdn}/iaas/api/machines/{id}?forceDelete=true&apiVersion={self.apiversion}"
        headers = {
            'accept': "application/json",
            'content-type': "application/json",
            'authorization': self.vratoken()
        }
        apioutput = requests.delete(url, headers=headers, verify=False)
        print(apioutput)