import requests
import base64
import re
from prettytable import PrettyTable
from requests.packages.urllib3.exceptions import InsecureRequestWarning
requests.packages.urllib3.disable_warnings(InsecureRequestWarning)


class vrLCM:
    def __init__(self, vrlcmurl, userName, password):
        self.vrlcmurl = vrlcmurl
        self.userName = userName
        self.password = password

    def lcmlogin(self):
        url = f"https://{self.vrlcmurl}/lcm/authzn/api/login"
        UserCredential = f"{self.userName}:{self.password}"
        encode = base64.b64encode(UserCredential.encode())
        token = encode.decode("utf-8")
        return token

    def lcmGetDNSServer(self):
        url = f"https://{self.vrlcmurl}/lcm/lcops/api/v2/settings/dns"
        lcmheaders = {
            'accept': "application/json",
            'authorization': "Basic " + self.lcmlogin(),
            'content-type': "application/json"
        }
        apioutput = requests.get(url, headers=lcmheaders, verify=False).json()
        view = PrettyTable(['DNS Server', 'IP'])
        for i in apioutput:
            view.add_row(
                (i['name'], i['hostName'])
            )
        print(view)

    def lcmGetDC(self):
        url = f"https://{self.vrlcmurl}/lcm/lcops/api/v2/datacenters"
        lcmheaders={
            'accept': "application/json",
            'authorization' : "Basic " + self.lcmlogin(),
            'content-type': "application/json"
        }
        apioutput = requests.get(url, headers=lcmheaders, verify=False).json()
        view = PrettyTable(
            ['DataCenterVMId', 'DCName', 'PrimaryLocation']
        )
        for i in apioutput:
            view.add_row(
                (i['dataCenterVmid'], i['dataCenterName'], i['primaryLocation'])
            )
        print(view)

    def lcmNewDC(self, namedc, location):
        url = f"https://{self.vrlcmurl}/lcm/lcops/api/v2/datacenters"
        lcmheaders = {
            'accept': "application/json",
            'authorization': "Basic " + self.lcmlogin(),
            'content-type': "application/json"
        }
        payload = f'{{"dataCenterName":"{namedc}","primaryLocation":"{location}"}}'
        apioutput = requests.post(url, headers=lcmheaders, data=payload, verify=False)
        output = str(apioutput)
        validation = re.search("200", output)
        if validation:
            print(f"New DataCenter {namedc} has been Created")
        else:
            print("Check the location or Make sure name does not exist")

        self.lcmGetDC()

    def lcmSetDC(self, dcvmid, nameDC, location):
        url = f"https://{self.vrlcmurl}/lcm/lcops/api/v2/datacenters/{dcvmid}"
        lcmheaders = {
            'accept': "application/json",
            'authorization': "Basic " + self.lcmlogin(),
            'content-type': "application/json"
        }
        payload = f'{{"dataCenterName":"{nameDC}","primaryLocation":"{location}"}}'
        apioutput = requests.put(url, headers=lcmheaders, data=payload, verify=False)
        output = str(apioutput)
        validation = re.search("200", output)
        if validation:
            print(f"DataCenter {nameDC} and it's location {location} is updated ")
            self.lcmGetDC()
        else:
            print("Please check the DataCenter ID using lcmGetDC or check the location")

    def lcmRemoveDC(self, dcvmid):
        url = f"https://{self.vrlcmurl}/lcm/lcops/api/v2/datacenters/{dcvmid}"
        lcmheaders = {
            'accept': "application/json",
            'authorization': "Basic " + self.lcmlogin(),
            'content-type': "application/json"
        }
        apioutput = requests.delete(url, headers=lcmheaders, verify=False)
        output = str(apioutput)
        validation = re.search("200", output)
        if validation:
            data = apioutput.json()
            req = str(data)
            print(f"DataCenter {dcvmid} deletion request {req} has been submitted")
            self.lcmGetDC()
        else:
            print("Please enter the correct DataCenterVMId ,Capture the ID using lcmGetDC ")

    def lcmGetDCEnvironment(self, dcvmid):
        url = f"https://{self.vrlcmurl}/lcm/lcops/api/v2/datacenters/{dcvmid}/environments"
        lcmheaders = {
            'accept': "application/json",
            'authorization': "Basic " + self.lcmlogin(),
            'content-type': "application/json"
        }
        apioutput = requests.get(url, headers=lcmheaders, verify=False).json()
        print(apioutput)

    def lcmGetDCvCenters(self, dcvmid):
        url = f"https://{self.vrlcmurl}/lcm/lcops/api/v2/datacenters/{dcvmid}/vcenters"
        lcmheaders = {
            'accept': "application/json",
            'authorization': "Basic " + self.lcmlogin(),
            'content-type': "application/json"
        }
        apioutput = requests.get(url, headers=lcmheaders, verify=False)
        output = str(apioutput)
        validation = re.search("200", output)
        if validation:
            data = apioutput.json()
            view = PrettyTable(
                ['vCenterHost', 'vCenterName', 'vcDataCollectionStatus', 'vcPassword', 'vcUsedAs', 'vcUsername']
            )
            for i in data:
                view.add_row(
                    (i['vCenterHost'], i['vCenterName'], i['vcDataCollectionStatus'], i['vcPassword'], i['vcUsedAs'], i['vcUsername'])
                )
            print(view)
        else:
            print("Please enter the Correct DCVmID , To get ID use lcmGetDC")

    def lcmGetvCdetails(self, dcvmid, vcname):
        url = f"https://{self.vrlcmurl}/lcm/lcops/api/v2/datacenters/{dcvmid}/vcenters/{vcname}"
        lcmheaders = {
            'accept': "application/json",
            'authorization': "Basic " + self.lcmlogin(),
            'content-type': "application/json"
        }
        apioutput = requests.get(url, headers=lcmheaders, verify=False).json()
        print(apioutput)

    def lcmTriggerDataCollection(self, dcvmid, vcname):
        url = f"https://{self.vrlcmurl}/lcm/lcops/api/v2/datacenters/{dcvmid}/vcenters/{vcname}/data-collection"
        lcmheaders = {
            'accept': "application/json",
            'authorization': "Basic " + self.lcmlogin(),
            'content-type': "application/json"
        }
        apioutput = requests.post(url, headers=lcmheaders, verify=False)
        output = str(apioutput)
        validation = re.search("200", output)
        if validation:
            data = str(apioutput.json())
            print(f"DataCollection request {data} for vCenter {vcname} has been triggered")
        else:
            print("Please check the DCVMID or vCenter name")

    def lcmValidatevCenter(self, dcvmid, vcname, vcHostName, vcPassword, vcUsedAs, vcUserName):
        url = f"https://{self.vrlcmurl}/lcm/lcops/api/v2/datacenters/{dcvmid}/vcenters/validate"
        lcmheaders = {
            'accept': "application/json",
            'authorization': "Basic " + self.lcmlogin(),
            'content-type': "application/json"
        }
        payload = f'{{"vCenterName":"{vcname}","vCenterHost":"{vcHostName}","vcPassword":"{vcPassword}","vcUsedAs":"{vcUsedAs}","vcUsername":"{vcUserName}"}}'
        apioutput = requests.post(url, headers=lcmheaders, data=payload, verify=False)
        output = str(apioutput)
        validation = re.search("200", output)
        if validation:
            data = str(apioutput.json())
            print(f"vCenter {vcname} validate request {data} has been submitted successfully")
        else:
            print("Please check the details and submit once again, To check the existing use lcmGetDCvCenters method")

    def lcmCreatevCenter(self, dcvmid, vcname, vcHostName, vcPassword, vcUsedAs, vcUserName):
        url = f"https://{self.vrlcmurl}/lcm/lcops/api/v2/datacenters/{dcvmid}/vcenters"
        lcmheaders = {
            'accept': "application/json",
            'authorization': "Basic " + self.lcmlogin(),
            'content-type': "application/json"
        }
        payload = f'{{"vCenterName":"{vcname}","vCenterHost":"{vcHostName}","vcPassword":"{vcPassword}","vcUsedAs":"{vcUsedAs}","vcUsername":"{vcUserName}"}}'
        apioutput = requests.post(url, headers=lcmheaders, data=payload, verify=False)
        output = str(apioutput)
        validation = re.search("200", output)
        if validation:
            data = str(apioutput.json())
            print(f"vCenter {vcname} creation request {data} has been submitted")
        else:
            print("Please provide correct details to add the vCenter")

    def lcmDeletevCenter(self, dcvmid, vcname):
        url = f"https://{self.vrlcmurl}/lcm/lcops/api/v2/datacenters/{dcvmid}/vcenters/{vcname}"
        lcmheaders = {
            'accept': "application/json",
            'authorization': "Basic " + self.lcmlogin(),
            'content-type': "application/json"
        }
        apioutput = requests.delete(url, headers=lcmheaders,verify=False)
        output = str(apioutput)
        validation = re.search("200", output)
        if validation:
            data = str(apioutput.json())
            print(f"vCenter {vcname} deletion request {data} has been submitted")
        else:
            print("Please provide correct details to add the vCenter")

    def lcmHealthcheck(self):
        url = f"https://{self.vrlcmurl}/lcm/health/api/v2/status"
        lcmheaders = {
            'accept': "application/json",
            'authorization': "Basic " + self.lcmlogin(),
            'content-type': "application/json"
        }
        apioutput = requests.get(url, headers=lcmheaders, verify=False)
        output = str(apioutput)
        validation = re.search("200", output)
        if validation:
            data = apioutput.json()
            view = PrettyTable(
                ['bootstrap', 'postgres', 'blackstone', 'vrlcm-server']
            )
            view.add_row(
                (data['bootstrap'], data['postgres'], data['blackstone'], data['vrlcm-server'])
            )
            print(view)
        else:
            print("check the swagger UI")

    def lcmGetFipsStatus(self):
        url = f"https://{self.vrlcmurl}/lcm/locker/api/security/fips"
        lcmheaders = {
            'accept': "application/json",
            'authorization': "Basic " + self.lcmlogin(),
            'content-type': "application/json"
        }
        apioutput = requests.get(url, headers=lcmheaders, verify=False)
        output = str(apioutput)
        validation = re.search("200", output)
        if validation:
            data = apioutput.json()
            view = PrettyTable(['Enabled', 'State', 'Description', 'Request'])
            view.add_row(
                (data['enabled'], data['state'], data['description'], data['request'])
            )
            print(view)
        else:
            print("check the health of VRLCM appliance, Note: If you have change the status It may take 3-5 Minutes")

    def lcmSetFIps(self, Enable):
        url = f"https://{self.vrlcmurl}/lcm/locker/api/security/fips"
        lcmheaders = {
            'accept': "application/json",
            'authorization': "Basic " + self.lcmlogin(),
            'content-type': "application/json"
        }
        payload = f'{{"description":"", "enabled":"{Enable}", "state":"ENABLED"}}'
        apioutput = requests.post(url, data=payload, headers=lcmheaders, verify=False)
        output = str(apioutput)
        validation = re.search("200", output)
        if validation:
            print(f"FIPS has been set to running = {Enable} \n Services will be restarted and may take 5 Minutes Please monitor using Browser")
        else:
            print("Make sure LCM health is good before running this \n Use lcmHealthcheck to confirm")

    def lcmGetPasswords(self):
        url = f"https://{self.vrlcmurl}/lcm/locker/api/v2/passwords"
        lcmheaders = {
            'accept': "application/json",
            'authorization': "Basic " + self.lcmlogin(),
            'content-type': "application/json"
        }
        apioutput = requests.get(url, headers=lcmheaders, verify=False)
        output = str(apioutput)
        validation =  re.search("200", output)
        view = PrettyTable(['vmid', 'alias', 'userName', 'password', 'passwordDescription', 'createdOn', 'lastUpdatedOn', 'referenced'])
        if validation:
            data = apioutput.json()
            totalpass = len(data['passwords'])
            for i in range(totalpass):
                if 'userName' not in data['passwords'][i].keys():
                    data['passwords'][i]['userName']='None'
                view.add_row((data['passwords'][i]['vmid'], data['passwords'][i]['alias'], data['passwords'][i]['userName'], data['passwords'][i]['password'], data['passwords'][i]['passwordDescription'], data['passwords'][i]['createdOn'],data['passwords'][i]['lastUpdatedOn'], data['passwords'][i]['referenced']))
            print(view)

    def lcmCreatePassword(self, alias, password, username, passwDesription):
        url = f"https://{self.vrlcmurl}/lcm/locker/api/v2/passwords"
        lcmheaders = {
            'accept': "application/json",
            'authorization': "Basic " + self.lcmlogin(),
            'content-type': "application/json"
        }
        payload = f'{{"alias":"{alias}", "password":"{password}", "userName": "{username}", "passwordDescription":"{passwDesription}"}}'
        apioutput = requests.post(url, data=payload, headers=lcmheaders, verify=False)
        output = str(apioutput)
        validation = re.search("201",output)
        if validation:
            print(f"New Password {alias} has been created")
            self.lcmGetPasswords()
        else:
            print("Make sure to provide the correct details")

    def lcmDeletePassword(self, vmid):
        url = f"https://{self.vrlcmurl}/lcm/locker/api/v2/passwords/{vmid}"
        lcmheaders = {
            'accept': "application/json",
            'authorization': "Basic " + self.lcmlogin(),
            'content-type': "application/json"
        }
        apioutput = requests.delete(url, headers=lcmheaders, verify=False)
        output = str(apioutput)
        validation = re.search("200", output)
        if validation:
            print("Delete Password request is triggered \n")
            self.lcmGetPasswords()

    def lcmEditPassword(self, alias, password, username, passwDesription, vmid):
        url = f"https://{self.vrlcmurl}/lcm/locker/api/v2/passwords/{vmid}"
        lcmheaders = {
            'accept': "application/json",
            'authorization': "Basic " + self.lcmlogin(),
            'content-type': "application/json"
        }
        payload = f'{{"alias":"{alias}", "password":"{password}", "userName": "{username}", "passwordDescription":"{passwDesription}"}}'
        apioutput = requests.patch(url, data=payload, headers=lcmheaders, verify=False)
        output = str(apioutput)
        validation = re.search("200", output)
        if validation:
            print("Password has been updated with below details")
            data = apioutput.json()
            view = PrettyTable(['alias', 'password', 'passwordDescription', 'userName', 'vmid'])
            view.add_row(
                (data['alias'], data['password'], data['passwordDescription'],  data['userName'], data['vmid'])
            )
            print(view)
        else:
            print("Please provide the correct vmid or password details")

    def lcmGetPasswordInfo(self, vmid):
        url = f"https://{self.vrlcmurl}/lcm/locker/api/v2/passwords/detail/{vmid}"
        lcmheaders = {
            'accept': "application/json",
            'authorization': "Basic " + self.lcmlogin(),
            'content-type': "application/json"
        }
        apioutput = requests.get(url, headers=lcmheaders, verify=False)
        output = str(apioutput)
        validation = re.search("200", output)
        if validation:
            data =apioutput.json()
            view = PrettyTable(['vmid', 'Alias', 'UserName', 'Password', 'PasswordDescription', 'CreatedOn', 'LastUpdatedOn'])
            view.add_row(
                (data['vmid'], data['alias'], data['userName'], data['password'], data['passwordDescription'], data['createdOn'], data['lastUpdatedOn'])
            )
            print(view)
        else:
            print("Provide the correct vmid")

    def lcmGetPwdReferEnvironment(self, vmid):
        url = f"https://{self.vrlcmurl}/lcm/locker/api/v2/references/ungrouped/{vmid}"
        lcmheaders = {
            'accept': "application/json",
            'authorization': "Basic " + self.lcmlogin(),
            'content-type': "application/json"
        }
        apioutput = requests.get(url, headers=lcmheaders, verify=False)

        output = str(apioutput)
        validation = re.search("200", output)
        if validation:
            data = apioutput.json()['references']
            View = PrettyTable(['vmid', 'LockerID', 'DestinationName', 'ReferenceType', 'type', 'envName', 'UserName'])
            for s in data:
                user = s['meta']
                Username = user.split('user')[1].replace('}', '').replace(':', '').replace('"', '')
                View.add_row(
                    (s['vmid'], s['lockerId'], s['destinationName'], s['referenceType'], s['type'],s['envName'], Username)
                     )
            print(View)
        else:
            print(apioutput)

    def lcmGetAllEnvironment(self):
        url = f"https://{self.vrlcmurl}/lcm/lcops/api/v2/environments"
        lcmheaders = {
            'accept': "application/json",
            'authorization': "Basic " + self.lcmlogin(),
            'content-type': "application/json"
        }
        apioutput = requests.get(url, headers= lcmheaders, verify=False)
        output = str(apioutput)
        validation = re.search("200", output)
        if validation:
            view = PrettyTable(['environmentId', 'environmentName', 'environmentStatus',
                                'ProductID', 'ProductVersion'])

            data = apioutput.json()
            for env in data:
                for product in env['products']:
                    ProductID = product['id']
                    ProductVersion = product['version']
                    view.add_row(
                        (env['environmentId'], env['environmentName'],
                         env['environmentStatus'], ProductID, ProductVersion)
                    )

            print(view)
        else:
            print(apioutput)

    def lcmSetEnvironmentName(self,envid,envname):
        url = f"https://{self.vrlcmurl}/lcm/lcops/api/v2/environments"
        lcmheaders = {
            'accept': "application/json",
            'authorization': "Basic " + self.lcmlogin(),
            'content-type': "application/json"
        }
        payload = f'{{"environmentId":"{envid}", "environmentName":"{envname}"}}'
        apioutput = requests.patch(url, data=payload, headers=lcmheaders, verify=False)
        output = str(apioutput)
        validation = re.search("200", output)
        if validation:
            data =apioutput.json()
            view = PrettyTable(['DataCenterName', 'DataCenterVmid', 'environmentId', 'environmentName', 'state',
                                'status'])
            view.add_row(
                (data['dataCenterName'], data['dataCenterVmid'], data['environmentId'], data['environmentName'],
                         data['state'], data['status'])
            )
            print(f"Environment has been renamed to {envname}")
            print(view)
        else:
            print(apioutput)

    def lcmTriggerInventorySncEnv(self,environmentId):
        url = f"https://{self.vrlcmurl}/lcm/lcops/api/v2/environments/{environmentId}/inventory-sync"
        lcmheaders = {
            'accept': "application/json",
            'authorization': "Basic " + self.lcmlogin(),
            'content-type': "application/json"
        }
        apioutput = requests.post(url, headers=lcmheaders, verify=False)
        output = str(apioutput)
        validation = re.search("200", output)
        if validation:
            data = apioutput.json()
            print(f"Request {data} has been submitted for inventory collection")
        else:
            print(apioutput)

    def lcmTriggerInventorySncAllEnv(self):
        url = f"https://{self.vrlcmurl}/lcm/lcops/api/v2/environments/inventory-sync"
        lcmheaders = {
            'accept': "application/json",
            'authorization': "Basic " + self.lcmlogin(),
            'content-type': "application/json"
        }
        apioutput = requests.post(url, headers=lcmheaders, verify=False)
        output = str(apioutput)
        validation = re.search("200", output)
        if validation:
            data = apioutput.json()
            print(f"Request {data} has been submitted to trigger Inventory sync for All Environment")
        else:
            print(apioutput)

    def lcmGetProductVMs(self, environmentId, productId):
        url = f"https://{self.vrlcmurl}/lcm/lcops/api/v2/environments/{environmentId}/products/{productId}/deployed-vms"
        lcmheaders = {
            'accept': "application/json",
            'authorization': "Basic " + self.lcmlogin(),
            'content-type': "application/json"
        }
        apioutput = requests.get(url, headers=lcmheaders, verify=False)
        output = str(apioutput)
        validation = re.search("200", output)
        if validation:
            data = apioutput.json()
            view = PrettyTable(['HostName', 'VMName:', 'vCenterName'])
            for s in data:
                view.add_row(
                    (s['hostname'], s['vmName'], s['vCenterHost'])
                )
            print(view)
        else:
            print(apioutput)

    def lcmTriggerInventorySyncProduct(self, environmentId , productId ):
        url = f"https://{self.vrlcmurl}/lcm/lcops/api/v2/environments/{environmentId}/products/{productId}/inventory-sync"
        lcmheaders = {
            'accept': "application/json",
            'authorization': "Basic " + self.lcmlogin(),
            'content-type': "application/json"
        }
        apioutput = requests.post(url, headers=lcmheaders, verify=False)
        output = str(apioutput)
        validation = re.search("200", output)
        if validation:
            data = apioutput.json()['requestId']
            print(f"Inventory sync request {data} has been submitted")
        else:
            print(apioutput)

    def lcmCreateSnapshotProduct(self, environmentId, productId, snapshotName, snapshotWithMemory):
        url = f"https://{self.vrlcmurl}/lcm/lcops/api/v2/environments/{environmentId}/products/{productId}/snapshots"
        lcmheaders = {
            'accept': "application/json",
            'authorization': "Basic " + self.lcmlogin(),
            'content-type': "application/json"
        }
        payload = f'{{"snapshotPrefix":"{snapshotName}", "snapshotWithMemory":"{snapshotWithMemory}"}}'
        apioutput = requests.post(url, data=payload, headers=lcmheaders, verify=False)
        output = str(apioutput)
        validation = re.search("200", output)
        if validation:
            data = apioutput.json()['requestId']
            print(f"Snapshot request {data} has been submitted")
        else:
            print(apioutput)

    def lcmGetSnapshotdetailsProduct(self, environmentId, productId):
        url = f"https://{self.vrlcmurl}/lcm/lcops/api/v2/environments/{environmentId}/products/{productId}/snapshots"
        lcmheaders = {
            'accept': "application/json",
            'authorization': "Basic " + self.lcmlogin(),
            'content-type': "application/json"
        }
        apioutput = requests.get(url, headers=lcmheaders, verify= False)
        output = str(apioutput)
        validation = re.search("200", output)
        if validation:
            view = PrettyTable(['CreationTime', 'SnapshotName', 'WithMemory'])
            data = apioutput.json()
            for s in data:
                view.add_row(
                    (s['snapshotGeneratedTime'], s['snapshotName'], s['snapshotWithMemory'])
                )
            print(view)
        else:
            print(apioutput)

    def lcmGetSSHStatus(self):
        url = f"https://{self.vrlcmurl}/lcm/lcops/api/v2/settings/ssh"
        lcmheaders = {
            'accept': "application/json",
            'authorization': "Basic " + self.lcmlogin(),
            'content-type': "application/json"
        }
        apioutput = requests.get(url, headers=lcmheaders, verify=False)
        output = str(apioutput)
        validation = re.search("200", output)
        if validation:
            data = apioutput.json()['sshEnabled']
            value1 = str(data)
            view = PrettyTable(['sshStatus', 'Status'])
            view.add_row(
                ('SSH-Running', value1)
            )
            print(view)
        else:
            print()

    def lcmSeTSSH(self, enable):
        url = f"https://{self.vrlcmurl}/lcm/lcops/api/v2/settings/ssh"
        lcmheaders = {
            'accept': "application/json",
            'authorization': "Basic " + self.lcmlogin(),
            'content-type': "application/json"
        }
        payload = f'{{"sshEnabled":"{enable}"}}'
        apioutput = requests.put(url, headers=lcmheaders, data=payload, verify=False)
        output = str(apioutput)
        validation = re.search("200", output)
        if validation:
            data = apioutput.json()['sshStatus']
            value1 = str(data)
            view = PrettyTable(['sshStatus', 'Status'])
            view.add_row(
                ('SSH-Running', value1)
            )
            print(view)
        else:
            print()

    def lcmGetSystemDetails(self):
        url = f"https://{self.vrlcmurl}/lcm/lcops/api/v2/settings/system-details"
        lcmheaders = {
            'accept': "application/json",
            'authorization': "Basic " + self.lcmlogin(),
            'content-type': "application/json"
        }
        apioutput = requests.get(url, headers=lcmheaders, verify=False)
        output = str(apioutput)
        validation = re.search("200", output)
        if validation:
            data = apioutput.json()
            view = PrettyTable(['Name', 'Version', 'PatchVersion', 'TotalStorage', 'UsedStorage', 'AvailableStorage',
                                'storagePercentage', 'BuildNumber', 'Vendor'])
            view.add_row(
                (data['name'], data['version'], data['patchVersion'], data['totalStorage'], data['usedStorage'],
                 data['availableStorage'], data['storagePercentage'], data['buildNumber'], data['vendor'])
            )
            print(view)
        else:
            print(apioutput)

    def lcmGetSystemDiskDetails(self):
        url = f"https://{self.vrlcmurl}/lcm/lcops/api/v2/settings/system-details/disks"
        lcmheaders = {
            'accept': "application/json",
            'authorization': "Basic " + self.lcmlogin(),
            'content-type': "application/json"
        }
        apioutput = requests.get(url, headers=lcmheaders, verify=False)
        output = str(apioutput)
        validation = re.search("200", output)
        if validation:
            data = apioutput.json()
            disk = apioutput.json()['diskStorageDTO']
            view = PrettyTable(['Name', 'Version', 'patchVersion', 'DiskName', 'TotalStorage', 'UsedStorage',
                                'AvailableStorage', 'StoragePercentage'])
            for s in disk:
                view.add_row(
                    (data['name'], data['version'], data['patchVersion'], s['diskName'], s['totalStorage'],
                     s['usedStorage'], s['availableStorage'], s['storagePercentage'])
                )
            print(view)

    def lcmExpandDiskSize(self, diskSizeInGb, vCenterHost, vcPassword, vcUsername):
        url = f"https://{self.vrlcmurl}/lcm/lcops/api/v2/settings/system-details/disks/expand"
        lcmheaders = {
            'accept': "application/json",
            'authorization': "Basic " + self.lcmlogin(),
            'content-type': "application/json"
        }
        payload = f'{{"diskSizeInGb":"{diskSizeInGb}", "vCenterHost": "{vCenterHost}", "vcPassword":"{vcPassword}",' \
                  f'"vcUsername":"{vcUsername}"}}'
        apioutput = requests.post(url, headers=lcmheaders, data=payload, verify=False)
        output = str(apioutput)
        validation = re.search("200", output)
        if validation:
            data = apioutput.json()
            print(f"Disk extend of size {diskSizeInGb} GB  request {data['requestId']}  is submitted")
        else:
            print(apioutput)
