import requests
import json
from prettytable import PrettyTable
from requests.packages.urllib3.exceptions import InsecureRequestWarning
requests.packages.urllib3.disable_warnings(InsecureRequestWarning)

class vraClass:
    def __init__(self, vrafqdn, username, password ,domain):
        self.vrafqdn = vrafqdn
        self.username = username
        self.password = password
        self.domain = domain
        url = f"https://{self.vrafqdn}/iaas/api/about"
        headers = {
            'accept': "application/json",
            'content-type': "application/json"
        }
        apioutput = requests.get(url, headers=headers, verify=False).json()['supportedApis']
        for i in apioutput:
            self.apiversion = i['apiVersion']

    def vratoken(self):
        refreshtokenurl = f"https://{self.vrafqdn}/csp/gateway/am/api/login?access_token"
        iaasUrl = f"https://{self.vrafqdn}/iaas/api/login?apiVersion={self.apiversion}"
        headers = {
            'accept': "application/json",
            'content-type': "application/json"
        }
        payload = {
            "username":self.username,
            "password":self.password,
            "domain": self.domain
        }
        apioutput = requests.post(refreshtokenurl, data=json.dumps(payload), verify=False, headers=headers)
        if apioutput.status_code == 200:
            refreshtoken = apioutput.json()['refresh_token']
            iaasPayload = f'{{"refreshToken": "{refreshtoken}"}}'
            iaasApiOutput = requests.post(iaasUrl, data=iaasPayload, headers=headers, verify=False).json()['token']
            bearerToken = "Bearer " + iaasApiOutput
            return bearerToken
        else:
            print(apioutput.status_code)
            print(apioutput.json())

    def getDeployments(self):
        url = f"https://{self.vrafqdn}/iaas/api/deployments?%24top=10000&apiVersion={self.apiversion}"
        headers = {
            'accept': "application/json",
            'content-type': "application/json",
            'authorization': self.vratoken()
        }
        api_output = requests.get(url, headers=headers, verify=False).json()['content']
        output_table = PrettyTable(['Number', 'ProjectID', 'DeploymentName', 'DeploymentID'])
        count = 0
        for i in api_output:
            count = count+1
            output_table.add_row(
                (count, i['projectId'], i['name'], i['id'])
            )
        print(output_table)

    def deleteDeployment(self, id):
        url = f"https://{self.vrafqdn}/iaas/api/deployments/{id}?apiVersion={self.apiversion}"
        headers = {
            'accept': "application/json",
            'content-type': "application/json",
            'authorization': self.vratoken()
        }
        apioutput = requests.delete(url, headers=headers, verify=False)
        print(apioutput)

    def getBlueprint(self):
        url = f"https://{self.vrafqdn}/blueprint/api/blueprints"
        headers = {
            'accept': "application/json",
            'content-type': "application/json",
            'authorization': self.vratoken()
        }
        apioutput = requests.get(url, headers=headers, verify=False).json()['content']
        table = PrettyTable(
            ['ID', 'Name', 'Status',  'CreatedBy','UpdatedBY', 'OrgID', 'ProjectID', 'projectName', 'totalVersions', 'totalReleasedVersions']
        )

        for i in apioutput:
            table.add_row(
                (i['id'], i['name'], i['status'], i['createdBy'], i['updatedBy'], i['orgId'], i['projectId'],i['projectName'], i['totalVersions'], i['totalReleasedVersions'])
            )
        print(table)

    def releaseBlueprint(self, id, version):
        url = f"https://{self.vrafqdn}/blueprint/api/blueprints/{id}/versions/{version}/actions/release"
        headers = {
            'accept': "application/json",
            'content-type': "application/json",
            'authorization': self.vratoken()
        }
        apioutput = requests.post(url, headers=headers, verify=False)
        print(apioutput)