import requests
import csv
import time
import json
import concurrent.futures
from prettytable import PrettyTable
from requests.packages.urllib3.exceptions import InsecureRequestWarning
requests.packages.urllib3.disable_warnings(InsecureRequestWarning)


def vRACloud_Login(token, cloudurl):
    start = time.time()
    url = f'https://{cloudurl}'
    api_version_url = f'{url}/iaas/api/about'
    headers = {
        'accept': "application/json",
        'content-type': "application/json"
    }
    output = requests.get(url=api_version_url, headers=headers, verify=False)
    if output.status_code == 200:
        latest_api_version = output.json()['latestApiVersion']
        apiversion = latest_api_version
    else:
        print(output.status_code)
    iaasUrl = f"{url}/iaas/api/login?apiVersion={apiversion}"
    headers = {
        'accept': "application/json",
        'content-type': "application/json"
    }
    refreshtoken = token
    iaasPayload = f'{{"refreshToken": "{refreshtoken}"}}'
    iaasApiOutput = requests.post(iaasUrl, data=iaasPayload, headers=headers, verify=False)
    if iaasApiOutput.status_code == 200:
        jsondata = iaasApiOutput.json()['token']
        bearerToken = "Bearer " + jsondata
        bearertoken = bearerToken
        end = time.time()
        timetaken = end - start
        print(f'Authentication Function Total Time Taken :  {timetaken} Seconds')
        return bearertoken
    else:
        print(iaasApiOutput)


def vRAOnPrem_Login(vrafqdn, username, password):
    url = f"https://{vrafqdn}/iaas/api/about"
    headers = {
        'accept': "application/json",
        'content-type': "application/json"
    }
    apioutput = requests.get(url, headers=headers, verify=False)
    if apioutput.status_code == 200:
        latest_api_version = apioutput.json()['latestApiVersion']
        apiversion = latest_api_version


    refreshtokenurl = f"https://{vrafqdn}/csp/gateway/am/api/login?access_token"
    iaasUrl = f"https://{vrafqdn}/iaas/api/login?apiVersion={apiversion}"
    headers = {
        'accept': "application/json",
        'content-type': "application/json"
    }
    payload = f'{{"username":"{username}","password":"{password}"}}'
    apioutput = requests.post(refreshtokenurl, data=payload, verify=False, headers=headers)
    refreshtoken = apioutput.json()['refresh_token']
    iaasPayload = f'{{"refreshToken": "{refreshtoken}"}}'
    iaasApiOutput = requests.post(iaasUrl, data=iaasPayload, headers=headers, verify=False)
    if iaasApiOutput.status_code == 200:
        jsondata = iaasApiOutput.json()['token']
        bearerToken = "Bearer " + jsondata
        bearertoken = bearerToken
        return bearertoken
    else:
        print(iaasApiOutput.status_code)


def get_Managed_vSphere_VMs(url, token, ExportToCSV=False, ExportToHTML=False, ExpertToJson=False):
    start = time.time()
    global mainurl
    mainurl = url
    url1 = f'https://{url}/deployment/api/deployments?size=100'
    headers = {
        'accept': "application/json",
        'content-type': "application/json",
        'authorization': token
    }
    totaldeploymentID = []
    csvheading = ['createdby', 'owner', 'VM Name', 'ClusterName', 'ID', 'cpuCount', 'totalMemoryMB', 'datastoreName',
                  'vmFolderPath', 'VMState']
    csvdata = []
    csvdict = {}
    api_output = requests.get(url1, headers=headers, verify=False)
    if api_output.status_code == 200:
        totalPage = api_output.json()['totalPages']
        total_page = list(range(0, totalPage + 1))

        def get_all_deployment_id(pagenumber):
            url = f'https://{mainurl}/deployment/api/deployments?size=100&page={pagenumber}'
            headers = {
                'accept': "application/json",
                'content-type': "application/json",
                'authorization': token
            }
            api_result = requests.get(url, headers=headers, verify=False)
            if api_result.status_code == 200:
                for i in api_result.json()['content']:
                    totaldeploymentID.append(i['id'])

        with concurrent.futures.ThreadPoolExecutor() as Executor:
            data = Executor.map(get_all_deployment_id, total_page)
        output_table = PrettyTable(
            ['createdby', 'owner', 'VM Name', 'ClusterName', 'ID', 'cpuCount', 'totalMemoryMB', 'datastoreName',
             'vmFolderPath', 'VMState'])
        output_table.border = True
        output_table.format = True

        def managevSpherevms(deploymentid):
            url2 = f"https://{mainurl}/deployment/api/deployments/{deploymentid}" \
                   f"/resources?resourceTypes=Cloud.vSphere.Machine"
            url3 = f"https://{mainurl}/deployment/api/deployments/{deploymentid}"
            headers = {
                'accept': "application/json",
                'content-type': "application/json",
                'authorization': token
            }
            api_output2 = requests.get(url2, headers=headers, verify=False).json()['content']
            api_output3 = requests.get(url3, headers=headers, verify=False).json()
            vm_owner = api_output3['ownedBy']
            vm_createdby = api_output3['createdBy']
            for s in api_output2:
                if 'datastoreName' not in s['properties'].keys():
                    s['properties']['datastoreName'] = ''
                csvdict['VMState'] = s['syncStatus']
                csvdict['VM Name'] = s['properties']['resourceName']
                csvdict['ClusterName'] = s['properties']['zone']
                csvdict['ID'] = s['id']
                csvdict['cpuCount'] = s['properties']['cpuCount']
                csvdict['totalMemoryMB'] = s['properties']['totalMemoryMB']
                csvdict['datastoreName'] = s['properties']['datastoreName']
                csvdict['vmFolderPath'] = s['properties']['vmFolderPath']
                csvdict['owner'] = vm_owner
                csvdict['createdby'] = vm_createdby
                csvdata.append(csvdict.copy())

                output_table.add_row(
                    (vm_createdby, vm_owner, s['properties']['resourceName'], s['properties']['zone'], s['id'],
                     s['properties']['cpuCount'],
                     s['properties']['totalMemoryMB'], s['properties']['datastoreName'],
                     s['properties']['vmFolderPath'], s['syncStatus'])
                )


        with concurrent.futures.ThreadPoolExecutor() as Executor:
            results = Executor.map(managevSpherevms, totaldeploymentID)

        print(output_table)
        if ExportToCSV:
            with open('managed.csv', 'w') as file:
                writer = csv.DictWriter(file, fieldnames=csvheading)
                writer.writeheader()
                writer.writerows(csvdata)
        if ExportToHTML:
            with open('managed.html', 'w') as file:
                file.write(output_table.get_html_string())
        if ExpertToJson:
            with open('managed.json', 'w') as File:
                json.dump(csvdata, File)
        end = time.time()
        timetaken = end - start
        print(f'Managed VM Function Total Time Taken  :  {timetaken} Seconds')
    else:
        print(api_output.status_code)




